/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.curseofpandora.content.reality;

import dev.xkmc.curseofpandora.content.complex.AttrAdder;
import dev.xkmc.curseofpandora.content.complex.IAttackListenerToken;
import dev.xkmc.curseofpandora.content.complex.ISlotAdderItem;
import dev.xkmc.curseofpandora.content.complex.ListTickingToken;
import dev.xkmc.curseofpandora.content.complex.SlotAdder;
import dev.xkmc.curseofpandora.content.reality.CursePandoraUtil;
import dev.xkmc.curseofpandora.event.ClientSpellText;
import dev.xkmc.curseofpandora.init.data.CoPConfig;
import dev.xkmc.curseofpandora.init.data.CoPDamageTypeGen;
import dev.xkmc.curseofpandora.init.data.CoPLangData;
import dev.xkmc.curseofpandora.init.registrate.CoPAttrs;
import dev.xkmc.l2damagetracker.contents.attack.AttackCache;
import dev.xkmc.l2damagetracker.contents.attack.DamageModifier;
import dev.xkmc.l2library.capability.conditionals.TokenKey;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import org.jetbrains.annotations.Nullable;

public class CurseOfSpellItem
extends ISlotAdderItem<Ticker> {
    private static final SlotAdder ADDER = SlotAdder.of("curse_of_spell", CoPConfig.COMMON.curse.curseOfSpellSlot);
    public static final TokenKey<Ticker> KEY = new TokenKey("curseofpandora", "curse_of_spell");
    private static final AttrAdder R = CursePandoraUtil.reality(KEY);
    private static final AttrAdder S = CursePandoraUtil.spell(KEY);

    public static double getItemSpellPenalty(double base, ItemStack stack) {
        if (stack.m_41619_() || !stack.m_41793_()) {
            return 0.0;
        }
        double level = 0.0;
        for (Integer i : stack.getAllEnchantments().values()) {
            if (i <= 0) continue;
            level += Math.pow(2.0, i - 1);
        }
        double val = base + (double)stack.getEnchantmentValue();
        return level / val / base * (Double)CoPConfig.COMMON.curse.curseOfSpellLoadFactor.get();
    }

    public static double getSpellPenalty(Player player) {
        double bonus = player.m_21133_((Attribute)CoPAttrs.SPELL.get());
        bonus = Math.max(1.0, bonus);
        double penalty = 0.0;
        for (EquipmentSlot e : EquipmentSlot.values()) {
            ItemStack stack = player.m_6844_(e);
            double val = CurseOfSpellItem.getItemSpellPenalty(bonus, stack);
            penalty += Math.max(0.0, val - 1.0);
        }
        return penalty;
    }

    public CurseOfSpellItem(Item.Properties properties) {
        super(properties, Ticker::new, ADDER, R, S);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        list.add((Component)CoPLangData.Reality.SPELL_1.get(new Object[0]).m_130940_(ChatFormatting.RED));
        if (level != null && level.m_5776_()) {
            ClientSpellText.addTotal(list);
        }
    }

    @SerialClass
    public static class Ticker
    extends ListTickingToken
    implements IAttackListenerToken {
        public Ticker() {
            super(List.of(ADDER, R, S));
        }

        @Override
        protected void tickImpl(Player player) {
            super.tickImpl(player);
            if (CurseOfSpellItem.getSpellPenalty(player) > 0.0 && player.f_19797_ % 20 == 0) {
                player.m_6469_(new DamageSource(CoPDamageTypeGen.forKey(player.m_9236_(), CoPDamageTypeGen.SPELL_CURSE)), 1.0f);
            }
        }

        @Override
        public void onPlayerDamaged(Player player, AttackCache cache) {
            LivingDamageEvent event = cache.getLivingDamageEvent();
            assert (event != null);
            if (event.getSource().m_276093_(CoPDamageTypeGen.SPELL_CURSE)) {
                return;
            }
            double penalty = CurseOfSpellItem.getSpellPenalty(player);
            if (penalty > 0.0) {
                double factor = (Double)CoPConfig.COMMON.curse.curseOfSpellDamageFactor.get();
                cache.addDealtModifier(DamageModifier.multTotal((float)((float)(1.0 + penalty * factor))));
            }
        }

        @Override
        public void onPlayerDamageTarget(Player player, AttackCache cache) {
            double penalty = CurseOfSpellItem.getSpellPenalty(player);
            if (penalty > 0.0) {
                double factor = (Double)CoPConfig.COMMON.curse.curseOfSpellWeakenFactor.get();
                cache.addDealtModifier(DamageModifier.multTotal((float)(1.0f / (float)(1.0 + penalty * factor))));
            }
        }
    }
}

